//---------------------------------------------------------------------------


#pragma hdrstop

#include "GLForm.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)


//---------------------------------------------------------------------------
//                    KONSTRUKTOR I DESTRUKTOR                             //
//---------------------------------------------------------------------------

#include <Dialogs.hpp>

__fastcall TGLForm::TGLForm(TComponent* Owner):TForm(Owner),kolorTla(clBlack)
{
   //zmiana wlasnosci okna
   //BorderStyle=bsSingle;
   //TBorderIcons ikonyFormy=BorderIcons;
   //ikonyFormy >> biMaximize;
   //BorderIcons=ikonyFormy;

   //biezace okno staje sie oknem OpenGL
   uchwytDC=GetDC(Handle);
   if (!GL_UstalFormatPikseli(uchwytDC)) ShowMessage("Nie udao si ustali formatu pikseli");
   uchwytRC=wglCreateContext(uchwytDC);
   if (uchwytRC==NULL) ShowMessage("Nie udao si pobra uchwytu kontekstu grafiki");
   if (!wglMakeCurrent(uchwytDC,uchwytRC)) ShowMessage("Inicjacja grafiki OpenGL nie powioda si");
   GL_UstawienieSceny();
   Caption=(AnsiString)"OpenGL "+(char*)glGetString(GL_VERSION);

   OnPaint=FormPaint;
}

__fastcall TGLForm::~TGLForm()
{
   wglMakeCurrent(NULL,NULL);
   wglDeleteContext(uchwytRC);
   ReleaseDC(Handle,uchwytDC);
   PostQuitMessage(0);
}

//---------------------------------------------------------------------------
//                         OBSLUGA OKNA OPENGL                             //
//---------------------------------------------------------------------------

bool TGLForm::GL_UstalFormatPikseli(HDC uchwytDC)
{
   PIXELFORMATDESCRIPTOR opisFormatuPikseli;
   ZeroMemory(&opisFormatuPikseli,sizeof(opisFormatuPikseli));
   opisFormatuPikseli.nVersion=1;
   opisFormatuPikseli.dwFlags=PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW |
   PFD_DOUBLEBUFFER; //w oknie, podwojne buforowanie
   opisFormatuPikseli.iPixelType=PFD_TYPE_RGBA; //typ koloru RGB
   opisFormatuPikseli.cColorBits=32; //jakosc kolorw 4 bajty
   opisFormatuPikseli.cDepthBits=16; //glebokosc bufora Z (z-buffer)
   opisFormatuPikseli.iLayerType=PFD_MAIN_PLANE;

   int formatPikseli=ChoosePixelFormat(uchwytDC,&opisFormatuPikseli);
   if (formatPikseli==0) return false;
   if (SetPixelFormat(uchwytDC,formatPikseli,&opisFormatuPikseli)!=true) return
   false;
   return true;
}

void TGLForm::GL_UstawienieSceny()
{
   glViewport(0,0,ClientWidth,ClientHeight); //okno OpenGL = wnetrze formy (domyslnie)

   //ustawienie punktu projekcji
   glMatrixMode(GL_PROJECTION); //przeczenie na macierz projekcji
   glLoadIdentity();
   //left,right,bottom,top,znear,zfar (clipping)
   float wsp=ClientHeight/(float)ClientWidth;
   glFrustum(-0.1, 0.1, wsp*-0.1, wsp*0.1, 0.3, 25.0);
   //mnozenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum
   glMatrixMode(GL_MODELVIEW); //powrt do macierzy widoku modelu
   glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie niewidocznych powierzchni
}

void __fastcall TGLForm::GL_RysujScene()
{
   //Przygotowanie bufora
   glClearColor(GetRValue(kolorTla)/255.0f,GetGValue(kolorTla)/255.0f,GetBValue(kolorTla)/255.0f,0.0);
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //czysci bufory
   glLoadIdentity(); //macierz model-widok = macierz jednostkowa
   glTranslatef(0.0, 0.0, -10.0); //odsuniecie calosci o 10

   //przeksztalcenia macierzy model-widok i rysowanie figur
   RysujScene();

   //Z bufora na ekran
   glFlush();
   SwapBuffers(uchwytDC);
}

//---------------------------------------------------------------------------
//                          METODY ZDARZENIOWE                             //
//---------------------------------------------------------------------------

void __fastcall TGLForm::FormPaint(TObject *Sender)
{
   GL_RysujScene();
}

//---------------------------------------------------------------------------
//                             INNE METODY                                 //
//---------------------------------------------------------------------------

void __fastcall TGLForm::Pomoc()
{
	AnsiString s=(AnsiString)"(c) Jacek Matulewski 2006-2007\n"+
			"OpenGL, wersja "+(char*)glGetString(GL_VERSION)+"\n"+
			"GLU, wersja "+(char*)gluGetString(GLU_VERSION);
	MessageBox(Handle,s.c_str(),"TGLForm",MB_OK | MB_ICONINFORMATION);
}

void __fastcall TGLForm::UstawKolorTla(TColor kolorTla)
{
   this->kolorTla=kolorTla;
   GL_RysujScene();
}
